	function [D] = bp_d_func(Z,NIN,NZ,q,z0_sqred)
	%  
	% Calculates the D value in the Z_frequency point z0_sqred. 
	% The D function is used for finding arc minimums for the 
	% lowpass filter case. 
	% Other input arguments are the number of attenuation poles 
	% at infinity NIN, the number of attenuation poles at the origin,
	% the passband quotient q = wb/wa and the attenuation pole vector Z.
	% 

	% Author: 			Per Loewenborg
    % Modified by:		LW
	% Copyright:		by authors - not released for commercial use
	% Version: 			1	
	% Known bugs:		None
	% Report bugs to:	larsw@isy.liu.se
	
	D = (NZ/2)*(q/(q^2-z0_sqred)) + (NIN/2)*(1/(1-z0_sqred)) + sum(Z./((Z.^2)-z0_sqred));
	
	
